<?php

namespace Application\Models;

use Doctrine\ORM\Mapping as ORM;

/**
 * Log
 *
 * @ORM\Table(name="log")
 * @ORM\Entity
 */
class Log
{
    /**
     * @var integer
     *
     * @ORM\Column(name="IDLOG", type="bigint", nullable=false)
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="IDENTITY")
     */
    private $idlog;

    /**
     * @var \DateTime
     *
     * @ORM\Column(name="DATELOG", type="datetime", nullable=true)
     */
    private $datelog;

    /**
     * @var string
     *
     * @ORM\Column(name="ACTION", type="text", nullable=true)
     */
    private $action;

    /**
     * @var \Application\Models\Utilisateur
     *
     * @ORM\ManyToOne(targetEntity="Application\Models\Utilisateur")
     * @ORM\JoinColumns({
     *   @ORM\JoinColumn(name="IDUTILISATEUR", referencedColumnName="IDUTILISATEUR")
     * })
     */
    private $idutilisateur;



    /**
     * Get idlog
     *
     * @return integer 
     */
    public function getIdlog()
    {
        return $this->idlog;
    }

    /**
     * Set datelog
     *
     * @param \DateTime $datelog
     * @return Log
     */
    public function setDatelog($datelog)
    {
        $this->datelog = $datelog;
    
        return $this;
    }

    /**
     * Get datelog
     *
     * @return \DateTime 
     */
    public function getDatelog()
    {
        return $this->datelog;
    }

    /**
     * Set action
     *
     * @param string $action
     * @return Log
     */
    public function setAction($action)
    {
        $this->action = $action;
    
        return $this;
    }

    /**
     * Get action
     *
     * @return string 
     */
    public function getAction()
    {
        return $this->action;
    }

    /**
     * Set idutilisateur
     *
     * @param \Application\Models\Utilisateur $idutilisateur
     * @return Log
     */
    public function setIdutilisateur(\Application\Models\Utilisateur $idutilisateur = null)
    {
        $this->idutilisateur = $idutilisateur;
    
        return $this;
    }

    /**
     * Get idutilisateur
     *
     * @return \Application\Models\Utilisateur 
     */
    public function getIdutilisateur()
    {
        return $this->idutilisateur;
    }
}